
import numpy as np
import tqdm

from src.imports.import_profile import import_profile

from src.clustering import \
    hierarchical_minavg, \
    hierarchical_minmax, \
    hierarchical_minmin


METHOD_FUNC = {
    "hierarchical_minmax": hierarchical_minmax,
    "hierarchical_minavg": hierarchical_minavg,
    "hierarchical_minmin": hierarchical_minmin,
}


if __name__ == "__main__":

    num_tests = 100
    num_voters = 1000
    num_candidates = 100
    lower_radius = 0.1
    upper_radius = 0.33

    num_clusters = 5

    rules = ['hierarchical_minavg']

    base_distances = ['norm_hamming', 'geom_hamming', 'rms_hamming',
                      'jaccard', 'geom_jaccard', 'rms_jaccard']

    for base_distance in base_distances:

        ALL_V_SETS = []
        ALL_C_SETS = []

        v_total_error = {method: [] for method in rules}
        c_total_error = {method: [] for method in rules}

        correct = {method: 0 for method in rules}

        for t in tqdm.tqdm(range(num_tests)):

            path = f'data/sampled/euclidean_2d/profiles/profile_{num_voters}_{num_candidates}_{t}_{lower_radius}_{upper_radius}'
            P = import_profile(path)

            num_v_clusters = num_voters
            num_c_clusters = num_clusters

            V_sets = {}
            C_sets = {}

            for method in rules:

                summary = METHOD_FUNC[method](np.array(P), num_v_clusters, num_c_clusters, base_distance=base_distance)
                summary.cluster_rename()

                V_sets[method] = summary.v_sets
                C_sets[method] = summary.c_sets

            ALL_V_SETS.append(V_sets)
            ALL_C_SETS.append(C_sets)

        for method in rules:
            v_sets_path = f"output/sampled/euclidean_2d/{method}_{base_distance}_v_sets_{num_clusters}_{num_voters}_{num_candidates}_{lower_radius}_{upper_radius}.txt"
            with open(v_sets_path, "w") as file:
                for i, v_set in enumerate(ALL_V_SETS):
                    file.write(f"Test {i}\n")
                    for j, v in enumerate(v_set[method]):
                        file.write(f"Voter Cluster {j}: {v}\n")
                    file.write("\n")
            c_sets_path = f"output/sampled/euclidean_2d/{method}_{base_distance}_c_sets_{num_clusters}_{num_voters}_{num_candidates}_{lower_radius}_{upper_radius}.txt"
            with open(c_sets_path, "w") as file:
                for i, c_set in enumerate(ALL_C_SETS):
                    file.write(f"Test {i}\n")
                    for j, c in enumerate(c_set[method]):
                        file.write(f"Candidate Cluster {j}: {c}\n")
                    file.write("\n")
